rm(list=ls())
#
# Setzen der Grundparameter:
#
n_rnd <- 200
n_zv_u <- 6  # unkorrellierte Zufallsvariable
n_zv_c <- 4  # korrelierte Zufallsvariable
#
# Simulation von Zufallszahlen fr n_zv verschiedene Zufallsvariable:
#
#Dat <- rlnorm(n_rnd*n_zv,2,0.2)   # lognormal
Dat <- rnorm(n_rnd*n_zv_u,0,1)     # standard-normal N(0,1)
#
# Erzeugen einer Datenmatrix mit n_zv Spalten fr die ZV:
#
Dat_mat <- matrix(Dat, ncol = n_rnd, byrow=F) 
# d.h. wir haben jetzt nrnd Zufallsvektoren der Dimension n_zv_u
#
# Transformationsmatrix:
# (der Einfachkeit halber mit Zufallszahlen erzeugt
#
rcoef <- rnorm(n_zv_u*n_zv_c,-1,1) 
TM <- matrix(rcoef, ncol=n_zv_u, byrow=F)
#
# Berechnung der korrelierten Zufallsvektoren:
Zcor <- TM%*%Dat_mat
cor(t(Zcor))
plot(as.data.frame(t(Zcor)))
# Aufgaben:
# 1. Wie wirkt sich die Transformationsmatrix auf die Korrelationen aus?
# 2. Wie sieht das Ganze aus bei Verwendung einer beliebigen Normalverteilung 
# 3. Probieren Sie das Verfahren mit anderen Verteilungstypen aus
# 4. Leiten Sie fr die N(0,1)-Verteilung eine theoretische 
#    Korrelationsmatrix her.
# 5. Vergleichen Sie die theoretischen und die simulierten 
#    Korrelationskoeffizieten
#